// config: norepeat

#include "GetObjects.js"

function SetActive( name, val )
{
	var btn = moi.ui.commandUI[name];
	btn.className = val ? 'active' : '';
}

function IsModeName( name )
{
	switch( name )
	{
		case 'HorizontalCenter':
		case 'HorizontalTop':
		case 'HorizontalBottom':
		case 'VerticalCenter':
		case 'VerticalLeft':
		case 'VerticalRight':
			return true;
	}
	
	return false;
}

function DoAlign()
{
	// First get the objects to align.

	var ui = moi.ui;
	
	var objectpicker = ui.createObjectPicker();
	objectpicker.allowEditPoints();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	// Now we want to pick the center point. Set up the UI.

	var mode = 'HorizontalCenter';
	
	var params = moi.command.getCommandLineParams();
	if ( IsModeName( params ) )
	{
		// If passed a specific mode by command line params use that.
		mode = params;
	}
	else
	{
		// Otherwise start with the last-used mode.
		try { mode = moi.command.getOption( 'AlignMode' ); }
		catch(e) { }
	}

	SetActive( mode, true );


	var factory = moi.command.createFactory( 'align' );
	factory.setInput( 0, objects );
	factory.setInput( 2, mode );

	
	ui.beginUIUpdate();
	ui.hideUI( 'SelectPrompt' );
	ui.hideUI( 'done' );
	ui.showUI( 'PointPrompt' );
	ui.showUI( 'AlignOptions' );
	
	if ( !factory.showMoveAsGroup )
		ui.hideUI( 'MoveAsGroup' );
	
	ui.endUIUpdate();

	
	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'MoveAsGroup', 'value', factory.getInput(3) );
	factory.disableUpdate( false );

	
	var pointpicker = ui.createPointPicker();
	pointpicker.bindResultFrame( factory.getInput(1) );

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
			break;
			
		if ( IsModeName( pointpicker.event ) )
		{
			SetActive( mode, false );
			mode = pointpicker.event;
			SetActive( mode, true );
			
			moi.command.setOption( 'AlignMode', mode );
			factory.setInput( 2, mode );
			factory.update();
		}
	}
	
	factory.commit();
}	

DoAlign();
